--- @param level CLevel	
--- @param character CCharacter
--- @return CDialog
function NewDialog_OnLevelFinished(level, character)
	local dialog               = New("CDialog")
	dialog.openCondition       = New("CCondition_LevelFinished");
	dialog.openCondition.level = level;
	dialog.character           = character;
	return dialog
end

--- @param character CCharacter	
--- @return CDialog
function NewDialog(character)
	local dialog         = New("CDialog")
	dialog.openCondition = nil;
	dialog.character     = character;
	return dialog
end

--- @param conditionShieldUp boolean
--- @param conditionPop number
--- @param conditionDialog CDialog
--- @param conditionDialogComplete boolean
--- @return CCondition_ShieldPopDialog
function NewCondition_ShieldPopDialog(conditionShieldUp, conditionPop, conditionDialog, conditionDialogComplete)
	local condition                   = New("CCondition_ShieldPopDialog")
	condition.conditionShieldUp       = conditionShieldUp
	condition.conditionPop            = conditionPop
	condition.conditionDialog         = conditionDialog
	condition.conditionDialogComplete = conditionDialogComplete
	return condition
end

--- @param ... string[]
--- @return CCharacter
function NewCharacter(...)
	local character = New("CCharacter")
	local faces = {}
	local args = { ... }
	for index, value in ipairs(args) do
		local faceElements = New("FaceElements")
		faceElements.face = NewCAssetSprite("GUI/Characters/Character_sprite 1", value[1])
		faceElements.eyes = NewCAssetSprite("GUI/Characters/Character_sprite 1", value[2])
		faceElements.mouth = NewCAssetSprite("GUI/Characters/Character_sprite 1", value[3])
		faces[index] = faceElements
	end
	character.faceTypeElements = faces
	character.eyeClosed = NewCAssetSprite("GUI/Characters/Character_sprite 1", "Character_eyes_closed")
	character.mouthClosed = NewCAssetSprite("GUI/Characters/Character_sprite 1", "Character_mouth_closed")
	return character
end

-- CHARACTERS

characters = {}

MOUTH_FULL = "Character_mouth_open_2"
MOUTH_HALF = "Character_mouth_open"

EYES_DEFAULT = "Character_eyes_open"
EYES_EYELASHES = "Character_eyes_open_2"

characters.earthGeneral = NewCharacter(
	{ "general_0_0", EYES_DEFAULT, MOUTH_FULL },
	{ "general_0_1", EYES_DEFAULT, MOUTH_HALF },
	{ "general_0_2", EYES_DEFAULT, MOUTH_HALF },
	{ "general_1_0", EYES_DEFAULT, MOUTH_FULL },
	{ "general_1_1", EYES_DEFAULT, MOUTH_HALF },
	{ "general_1_2", EYES_DEFAULT, MOUTH_HALF }
)
characters.earthGeneral.animate = true

characters.earthPresident = NewCharacter(
	{ "president_0_0", EYES_DEFAULT, MOUTH_HALF },
	{ "president_0_1", EYES_DEFAULT, MOUTH_HALF },
	{ "president_0_2", EYES_DEFAULT, MOUTH_HALF },
	{ "president_1_0", EYES_DEFAULT, MOUTH_FULL },
	{ "president_1_1", EYES_DEFAULT, MOUTH_FULL },
	{ "president_1_2", EYES_DEFAULT, MOUTH_FULL },
	{ "president_2_0", EYES_EYELASHES, MOUTH_FULL },
	{ "president_2_1", EYES_EYELASHES, MOUTH_FULL },
	{ "president_2_2", EYES_EYELASHES, MOUTH_FULL }
)
characters.earthPresident.animate = true

characters.planetScientist = NewCharacter(
	{ "scientist_0_0", EYES_EYELASHES, MOUTH_FULL },
	{ "scientist_0_1", EYES_EYELASHES, MOUTH_FULL },
	{ "scientist_0_2", EYES_EYELASHES, MOUTH_FULL },
	{ "scientist_1_0", EYES_EYELASHES, MOUTH_FULL },
	{ "scientist_1_1", EYES_EYELASHES, MOUTH_FULL },
	{ "scientist_1_2", EYES_EYELASHES, MOUTH_FULL },
	{ "scientist_2_0", EYES_DEFAULT, MOUTH_FULL },
	{ "scientist_2_1", EYES_DEFAULT, MOUTH_FULL },
	{ "scientist_2_2", EYES_DEFAULT, MOUTH_FULL }
)
characters.planetScientist.animate = true

characters.councilElder = NewCharacter(
	{ "elder_0_0", EYES_DEFAULT, MOUTH_FULL },
	{ "elder_0_1", EYES_DEFAULT, MOUTH_FULL },
	{ "elder_0_2", EYES_DEFAULT, MOUTH_HALF },
	{ "elder_1_0", EYES_DEFAULT, MOUTH_FULL },
	{ "elder_1_1", EYES_DEFAULT, MOUTH_FULL },
	{ "elder_1_2", EYES_DEFAULT, MOUTH_FULL },
	{ "elder_2_0", EYES_EYELASHES, MOUTH_FULL },
	{ "elder_2_1", EYES_EYELASHES, MOUTH_FULL },
	{ "elder_2_2", EYES_EYELASHES, MOUTH_FULL }
)
characters.councilElder.animate = true

GGame.characters = CreateLuaEntityList("CCharacter", characters)


-- DIALOGS:

local dialogs = {}

dialogs.start = NewDialog(characters.earthPresident);
dialogs.start.visibleInLevel = 1

dialogs.level2 = NewDialog_OnLevelFinished(levels.level1, characters.earthPresident);

dialogs.level3 = NewDialog_OnLevelFinished(levels.level2, characters.planetScientist);

dialogs.level4 = NewDialog_OnLevelFinished(levels.level3, characters.earthPresident);

dialogs.level5 = NewDialog_OnLevelFinished(levels.level4, characters.planetScientist);

dialogs.level6 = NewDialog_OnLevelFinished(levels.level5, characters.earthPresident);
dialogs.level6b = NewDialog_OnLevelFinished(levels.level5, characters.earthPresident);

dialogs.level7 = NewDialog_OnLevelFinished(levels.level6, characters.earthPresident);
dialogs.level7b = NewDialog_OnLevelFinished(levels.level6, characters.planetScientist);

dialogs.level8 = NewDialog_OnLevelFinished(levels.level7, characters.earthPresident);

dialogs.level9 = NewDialog_OnLevelFinished(levels.level8, characters.planetScientist);
dialogs.level9b = NewDialog_OnLevelFinished(levels.level8, characters.earthPresident);

dialogs.level10 = NewDialog_OnLevelFinished(levels.level9, characters.earthPresident);
dialogs.level10b = NewDialog_OnLevelFinished(levels.level9, characters.planetScientist);

dialogs.level11 = NewDialog_OnLevelFinished(levels.level10, characters.planetScientist);
dialogs.level11b = NewDialog_OnLevelFinished(levels.level10, characters.earthPresident);

dialogs.reminderTemperature = NewDialog(characters.planetScientist)
dialogs.reminderTemperature.openCondition = New("CCondition_TemperatureTooLow")
dialogs.reminderTemperature.openCondition.levelAt = levels.level11
dialogs.reminderTemperature.openCondition.levelProgress = 0.83 -- 2500 pop
dialogs.reminderTemperature.openCondition.temperatureIncreaseMax = 10

-- space lift levels:
dialogs.level12 = NewDialog_OnLevelFinished(levels.level11, characters.planetScientist);
dialogs.level12b = NewDialog_OnLevelFinished(levels.level11, characters.earthPresident);
dialogs.level12b.onDialogComplete = New("CDialogAnimation_TpOnSpaceLift")
dialogs.level12c = NewDialog_OnLevelFinished(levels.level11, characters.planetScientist);

dialogs.level13 = NewDialog_OnLevelFinished(levels.level12, characters.earthPresident);

dialogs.level14 = NewDialog_OnLevelFinished(levels.level13, characters.planetScientist);

dialogs.level15 = NewDialog_OnLevelFinished(levels.level14, characters.planetScientist);
dialogs.level15b = NewDialog_OnLevelFinished(levels.level14, characters.earthPresident);
dialogs.level15c = NewDialog_OnLevelFinished(levels.level14, characters.councilElder);

dialogs.level16 = NewDialog_OnLevelFinished(levels.level15, characters.earthGeneral);
dialogs.level16b = NewDialog_OnLevelFinished(levels.level15, characters.councilElder);

dialogs.reminderTrees = NewDialog(characters.planetScientist)
dialogs.reminderTrees.openCondition = New("CCondition_TreesAmountTooLow")
dialogs.reminderTrees.openCondition.levelAt = levels.level16
dialogs.reminderTrees.openCondition.levelProgress = 0.83 -- 2500 pop
dialogs.reminderTrees.openCondition.treesAmountMax = 10000

dialogs.level17 = NewDialog_OnLevelFinished(levels.level16, characters.earthGeneral);
dialogs.level17b = NewDialog_OnLevelFinished(levels.level16, characters.councilElder);

dialogs.level18 = NewDialog_OnLevelFinished(levels.level17, characters.earthGeneral);
dialogs.level18b = NewDialog_OnLevelFinished(levels.level17, characters.councilElder);

dialogs.level19 = NewDialog_OnLevelFinished(levels.level18, characters.councilElder);
dialogs.level19.openCondition.checkOnLaterLevels = true
dialogs.level19.onDialogComplete = New("CDialogAnimation_SpaceLiftExplosion")
dialogs.level19bis = NewDialog_OnLevelFinished(levels.level18, characters.councilElder);
dialogs.level19bis.openCondition.checkOnLaterLevels = true

-- defense levels:

dialogs.level20 = NewDialog_OnLevelFinished(levels.level19, characters.councilElder);
dialogs.level20bis = NewDialog_OnLevelFinished(levels.level19, characters.planetScientist);

dialogs.level21 = NewDialog_OnLevelFinished(levels.level20, characters.earthGeneral)
dialogs.level21bis = NewDialog_OnLevelFinished(levels.level20, characters.councilElder)
dialogs.level21ter = NewDialog_OnLevelFinished(levels.level20, characters.planetScientist)

dialogs.level22 = NewDialog_OnLevelFinished(levels.level21, characters.planetScientist)

dialogs.level23 = NewDialog_OnLevelFinished(levels.level22, characters.earthGeneral) -- unlock shield, obj 1M
dialogs.level23bis = NewDialog_OnLevelFinished(levels.level22, characters.councilElder)


dialogs.shield_bomb = NewDialog(characters.councilElder)
dialogs.noShield_1stBomb = NewDialog(characters.councilElder)
dialogs.noShield_1stBomb_bis = NewDialog(characters.councilElder)
dialogs.noShield_safe = NewDialog(characters.councilElder)
dialogs.noShield_safe_bis = NewDialog(characters.councilElder)
dialogs.noShield_otherBomb = NewDialog(characters.councilElder)
dialogs.shield_bomb_bis = NewDialog(characters.councilElder)

dialogs.noShield_1stBomb.openCondition = NewCondition_ShieldPopDialog(false, 500000, dialogs.shield_bomb, false) -- shield not up, and 500k pop
dialogs.noShield_1stBomb.onDialogComplete = New("CDialogAnimation_CityBombing")
dialogs.noShield_1stBomb.visibleInLevel = 23
dialogs.noShield_1stBomb_bis.openCondition = NewCondition_ShieldPopDialog(false, 0, dialogs.noShield_1stBomb, true) -- dialog sequel
dialogs.noShield_1stBomb_bis.visibleInLevel = 23
dialogs.noShield_1stBomb_bis.onDialogComplete = New("CDialogAnimation_ObjectiveChangedMessage")

dialogs.noShield_safe.openCondition = NewCondition_ShieldPopDialog(true, 0, dialogs.noShield_1stBomb, true)     -- bomb has hit, and shield up
dialogs.noShield_safe.visibleInLevel = 23
dialogs.noShield_safe_bis.openCondition = NewCondition_ShieldPopDialog(true, 0, dialogs.noShield_1stBomb, true) -- dialog sequel
dialogs.noShield_safe_bis.visibleInLevel = 23
dialogs.noShield_safe_bis.onDialogComplete = New("CDialogAnimation_ObjectiveChangedMessage")

dialogs.noShield_otherBomb.openCondition = NewCondition_ShieldPopDialog(false, 500000, dialogs.noShield_1stBomb, true) -- bomb has hit, and 500k pop
dialogs.noShield_otherBomb.openCondition.conditionAnotherDialogUncomplete = dialogs.noShield_safe;                     -- so it is not repeated after shield has been set
dialogs.noShield_otherBomb.onDialogComplete = New("CDialogAnimation_CityBombing")
dialogs.noShield_otherBomb.completeOnRead = false
dialogs.noShield_otherBomb.visibleInLevel = 23
dialogs.noShield_otherBomb.waitAfterBomb = 300

dialogs.shield_bomb.openCondition = NewCondition_ShieldPopDialog(true, 500000, dialogs.noShield_1stBomb, false) -- no bomb has hit, and shield up, and 500k pop
dialogs.shield_bomb.onDialogComplete = New("CDialogAnimation_CityBombing")
dialogs.shield_bomb.visibleInLevel = 23

dialogs.shield_bomb_bis.openCondition = NewCondition_ShieldPopDialog(true, 0, dialogs.shield_bomb, true) -- dialog sequel
dialogs.shield_bomb_bis.visibleInLevel = 23
dialogs.shield_bomb_bis.onDialogComplete = New("CDialogAnimation_AchCityProtection")


dialogs.earthBad = NewDialog_OnLevelFinished(levels.level25, characters.councilElder)
dialogs.earthBad.openCondition = New("CCondition_Pop")
dialogs.earthBad.openCondition.population = 700000
dialogs.earthBad.visibleInLevel = 23

dialogs.earthReallyBad = NewDialog_OnLevelFinished(levels.level25, characters.councilElder)
dialogs.earthReallyBad.openCondition = New("CCondition_Pop")
dialogs.earthReallyBad.openCondition.population = 800000
dialogs.earthReallyBad.visibleInLevel = 23

levels.level23.temporaryObjective_DialogRequiredOn = dialogs.noShield_1stBomb_bis
levels.level23.temporaryObjective_DialogRequiredOff = dialogs.noShield_safe

dialogs.oxygen = NewDialog(characters.planetScientist)
dialogs.oxygen.openCondition = New("CCondition_Oxygen")
dialogs.oxygen.openCondition.oxygen = 1

dialogs.level26a = NewDialog_OnLevelFinished(levels.level23, characters.planetScientist)
dialogs.level26 = NewDialog_OnLevelFinished(levels.level23, characters.councilElder)


GGame.dialogs = CreateLuaEntityList("CDialog", dialogs)
